import { Ping, StartApplication } from '@signageos/actions/dist/Application/applicationActions';
import wait from '@signageos/lib/dist/Timer/wait';
import { call, put, race, take, takeEvery } from 'redux-saga/effects';
import { ChangeSubscriptionToOpen, ChangeSubscriptionToPlatform } from '../../Device/Configuration/deviceConfigurationActions';

const PLATFORM_PERIOD = 30e3;
const OPEN_PERIOD = 30 * 60e3;

export function* pinging() {
	let isPlatform: boolean = false;
	yield takeEvery(ChangeSubscriptionToOpen, function* (): IterableIterator<any> {
		isPlatform = false;
	});
	yield takeEvery(ChangeSubscriptionToPlatform, function* (): IterableIterator<any> {
		isPlatform = true;
	});
	yield takeEvery(StartApplication, function* () {
		try {
			yield wait(1e3);

			while (true) {
				yield put({ type: Ping } as Ping);
				const nextPingInMs = isPlatform ? PLATFORM_PERIOD : OPEN_PERIOD;
				yield race({
					platform: take(ChangeSubscriptionToPlatform),
					open: take(ChangeSubscriptionToOpen),
					wait: call(wait, nextPingInMs),
				});
			}
		} catch (error) {
			console.error('pinging failed', error);
		}
	});
}
