import nodeFetch, * as nodeFetchExports from 'node-fetch';
import globalThis from '../ponyfill/globalThis';

/*
	Perform condition select fetch according to environment setting from  webpack.DefinePlugin
	For apps running in brows it select window.fetch and for apps using node it require node-fetch
	It is dependent on process.env.ISOMORPHIC_TARGET in webpack.config.ts in each core app
 */
export async function fetch(
	url: RequestInfo & nodeFetchExports.RequestInfo,
	init?: RequestInit & nodeFetchExports.RequestInit,
): Promise<Response> {
	if (process.env.ISOMORPHIC_TARGET === 'node') {
		const response = await nodeFetch(url, init);
		return response as unknown as Response;
	} else {
		return await globalThis.fetch(url as RequestInfo, init as RequestInit);
	}
}

export interface FetchError extends Error {
	name: 'FetchError';
	type: string;
	code?: string;
	errno?: string;
}

export const Response = process.env.ISOMORPHIC_TARGET === 'node' ? nodeFetchExports.Response : globalThis.Response;
export const Request = process.env.ISOMORPHIC_TARGET === 'node' ? nodeFetchExports.Request : globalThis.Request;
export const Headers = process.env.ISOMORPHIC_TARGET === 'node' ? nodeFetchExports.Headers : globalThis.Headers;
