interface IIntegerGenerator {
	getIntegerInclusive(min: number, max: number): number;
}

class IntegerGenerator implements IIntegerGenerator {
	public getIntegerInclusive(min: number, max: number): number {
		min = Math.ceil(min);
		max = Math.floor(max);
		return Math.floor(Math.random() * (max - min + 1)) + min;
	}
}

export default IntegerGenerator;

const gen = new IntegerGenerator();

const getIntegerInclusive = (min: number, max: number): number => {
	return gen.getIntegerInclusive(min, max);
};

export { getIntegerInclusive };
