import { combineReducers, Reducer, ReducersMapObject } from 'redux';
import { socket, ISocketState } from './Socket/socketReducers';
import { device, IDeviceState } from './Device/deviceReducers';
import { organization, IOrganizationState } from './Organization/organizationReducers';
import { deviceAuthentication, IDeviceAuthenticationState } from './Device/deviceAuthenticationReducers';
import { deviceVerification, IDeviceVerificationState } from '../Device/Verification/deviceVerificationReducers';
import { deviceRemoteControl, IDeviceRemoteControlState } from './Device/RemoteControl/deviceRemoteControlReducers';
import { network, INetworkState } from './Network/networkReducers';
import { keyboard, IKeyboardState } from './Input/keyboardReducers';
import { authentication, IAuthenticationState } from '../Authentication/authenticationReducers';
import { applet, IAppletState } from './Applet/appletReducers';
import { application, IApplicationState } from './Application/applicationReducers';
import { debug, IDebugState } from './Device/Debug/deviceDebugReducers';
import { bundledApplet, IBundledAppletState } from './Applet/BundledApplet/bundledAppletReducer';
import { license, ILicenseState } from './License/licenseReducers';
import { deviceConnect, IDeviceConnectState } from './Device/Connect/deviceConnectReducers';

export interface IFrontState {
	applet: IAppletState;
	bundledApplet: IBundledAppletState;
	authentication: IAuthenticationState;
	socket: ISocketState;
	device: IDeviceState;
	debug: IDebugState;
	organization: IOrganizationState;
	deviceAuthentication: IDeviceAuthenticationState;
	deviceVerification: IDeviceVerificationState;
	deviceRemoteControl: IDeviceRemoteControlState;
	network: INetworkState;
	keyboard: IKeyboardState;
	application: IApplicationState;
	license: ILicenseState;
	deviceConnect: IDeviceConnectState;
}

export const frontReducer: Reducer<IFrontState> = combineReducers<IFrontState>({
	applet,
	bundledApplet,
	authentication,
	socket,
	device,
	debug,
	organization,
	deviceAuthentication,
	deviceVerification,
	deviceRemoteControl,
	network,
	keyboard,
	application,
	license,
	deviceConnect,
} as ReducersMapObject);
