import * as React from 'react';
import { connect } from 'react-redux';
import { IFrontState } from '../../frontReducers';
import OfflineIcon from './OfflineIcon';
import { Action } from 'redux';
import CornerStatusIndicator from '../Application/Status/CornerStatusIndicator';
import styles from '../Application/Status/StatusBar.module.sass';

export interface IStateProps {
	debug: boolean;
	isConnected: boolean;
}
export interface IDispatchProps {}

export class NetworkIndicator extends React.PureComponent<IStateProps & IDispatchProps, {}> {
	public render() {
		const { isConnected, debug } = this.props;

		if (!isConnected) {
			return (
				<div>
					{debug ? (
						<div className={styles.info}>
							<OfflineIcon />
						</div>
					) : null}
					<CornerStatusIndicator top right />
				</div>
			);
		} else {
			return null;
		}
	}
}
export default connect(
	(state: IFrontState) => ({
		isConnected: state.network.connected,
		debug: state.debug.debugOn,
	}),
	(_dispatch: (action: Action) => void) => ({}),
)(NetworkIndicator);
