import * as React from 'react';
import { useState, useEffect } from 'react';
import styles from './TimeInfo.module.sass';
import dayjs from 'dayjs';
import { DangerIconSmall } from '../Application/Icons/DangerIcon';

export interface IProps {
	timestamp: number | null;
	timezone: string | null;
}

declare const __CURRENT_YEAR__: string;

export default function TimeInfo(props: IProps) {
	const [currentTimestamp, setCurrentTimestamp] = useState(props.timestamp);

	useEffect(() => {
		const interval = setInterval(() => {
			setCurrentTimestamp(Date.now());
		}, 5000);

		return () => clearInterval(interval);
	}, []);

	function showTimezone(timezone: string | null) {
		if (timezone) {
			return `(${timezone})`;
		}
		return null;
	}

	// We need to show a warning if the year is lower than 3 of actual year
	function validateYear(timestamp: number) {
		if (dayjs(timestamp).year() < Number(__CURRENT_YEAR__) - 3) {
			return <DangerIconSmall />;
		}
	}

	// On initialization there might be no timestamp, we dont want to show anything in that case
	if (!currentTimestamp) {
		return null;
	}

	return (
		<div className={styles.timeInfo}>
			<span className={styles.timeLabel}>Time:</span>
			<span>
				{dayjs(currentTimestamp).format('ddd, MMM DD, YYYY h:mm A')} {showTimezone(props.timezone)} {validateYear(currentTimestamp)}
			</span>
		</div>
	);
}
