import * as React from 'react';
import { connect } from 'react-redux';

import { IFrontState } from '../../../frontReducers';
import { Action } from 'redux';

import CheckingVerificationIcon from './CheckingVerificationIcon';
import CornerStatusIndicator from '../../Application/Status/CornerStatusIndicator';

import stylesStatusIcon from '../../Application/Status/StatusBar.module.sass';
import styles from './DeviceVerificationStatus.module.sass';

export interface IStateProps {
	debug: boolean;
	verified: boolean;
}

class DeviceVerificationStatus extends React.PureComponent<IStateProps> {
	public render() {
		const { verified, debug } = this.props;

		if (verified === null) {
			return (
				<div>
					{debug ? (
						<div className={stylesStatusIcon.info}>
							<CheckingVerificationIcon />
						</div>
					) : null}
					<CornerStatusIndicator bottom left customClass={styles.indicator} />
				</div>
			);
		} else {
			return null;
		}
	}
}

export default connect(
	(state: IFrontState) => ({
		verified: state.deviceVerification.verified,
		debug: state.debug.debugOn,
	}),
	(_dispatch: (action: Action) => void) => ({}),
)(DeviceVerificationStatus);
