import * as React from 'react';
import classNames from 'classnames';

import styles from './CornerStatusIndicator.module.sass';

interface CornerStatusIndicatorProps {
	top?: boolean;
	bottom?: boolean;
	left?: boolean;
	right?: boolean;
	customClass?: string;
}

export default class CornerStatusIndicator extends React.PureComponent<CornerStatusIndicatorProps, any> {
	public render() {
		this.validateProps();

		const { customClass } = this.props;
		const pixelClassName = [styles.pixel, this.getPosition(), customClass].join(' ');

		return (
			<div
				className={classNames(pixelClassName, 'global-corner-indicator', {
					'global-top': !!this.props.top,
					'global-bottom': !!this.props.bottom,
					'global-left': !!this.props.left,
					'global-right': !!this.props.right,
				})}
			></div>
		);
	}

	private getPosition = (): string => {
		const { top, bottom, left, right } = this.props;
		let positionClassName: string = styles.bottomRight;

		if (top && left) {
			positionClassName = styles.topLeft;
		} else if (top && right) {
			positionClassName = styles.topRight;
		} else if (bottom && left) {
			positionClassName = styles.bottomLeft;
		}

		return positionClassName;
	};

	private validateProps = (): void => {
		const ERROR_MSG = 'Invalid combination of props.';
		const ERROR_TOP_BOTTOM = "Can't use top and bottom at the same time.";
		const ERROR_LEFT_RIGHT = "Can't use left and right at the same time.";
		const { top, bottom, left, right } = this.props;

		let errorMessageArr: string[] = [ERROR_MSG];

		if (top && bottom) {
			errorMessageArr.push(ERROR_TOP_BOTTOM);
		}

		if (left && right) {
			errorMessageArr.push(ERROR_LEFT_RIGHT);
		}

		if (errorMessageArr.length > 1) {
			throw new Error(errorMessageArr.join(' '));
		}
	};
}
