import * as React from 'react';
import NumericKeyboard from '../Input/NumericKeyboard';
import ActiveApplet from '../Applet/ActiveApplet';
import StatusBar from './Status/StatusBar';
import DeviceVerification from '../Device/Verification/DeviceVerification';
import { connect, Dispatch } from 'react-redux';
import { IFrontState } from '../../frontReducers';

export interface IStateProps {
	activeAppletLoaded: boolean;
	isCachedAppletReady: boolean;
	isBundledApplet: boolean;
	dispatch: Dispatch<never>;
}

class DisplayBody extends React.PureComponent<IStateProps> {
	public render() {
		return (
			<div>
				<StatusBar />
				<NumericKeyboard />
				{this.props.isBundledApplet || this.props.isCachedAppletReady || this.props.activeAppletLoaded ? (
					<ActiveApplet />
				) : (
					<DeviceVerification />
				)}
			</div>
		);
	}
}

export default connect((state: IFrontState) => ({
	activeAppletLoaded: state.applet.activeTimingChecksum !== null || state.applet.activeAppletMissing,
	isCachedAppletReady: state.applet.isCachedAppletReady,
	isBundledApplet: state.bundledApplet.bundledApplet !== null,
}))(DisplayBody);
