import { put } from 'redux-saga/effects';
import { IFrontState } from '../frontReducers';
import IDriver from '../../NativeDevice/Front/IFrontDriver';
import ITouchEventMessage from '../../NativeDevice/Front/ITouchEventMessage';
import { sendMessageToActiveAppletIfExists } from '../Applet/sendAppletMessage';
import { HandleMotion } from '@signageos/actions/dist/Input/motionActions';
import { createChannel, takeEvery as takeEveryChannelMessage } from '../../ReduxSaga/channels';
import GestureAction from '../../NativeDevice/Input/GestureAction';
import { handleTouch } from './touchGestureResolver';
import Debug from 'debug';

const debug = Debug('@signageos/front-display:Front:Touch:touchSaga');

export function* touchSaga(messageTypePrefix: string, getState: () => IFrontState, getNativeDriver: () => IDriver, window: Window) {
	const touchEventChannel = createTouchEventChannel(window);

	yield takeEveryChannelMessage(touchEventChannel, function* (event: TouchEvent): any {
		try {
			for (let gesture of handleTouch(event.type)) {
				yield put({
					type: HandleMotion,
					gestureAction: GestureAction[gesture],
				} as HandleMotion);
			}
		} catch (error) {
			debug('event ignored', event);
		}
	});

	getNativeDriver().forwardTouchEvents((data: ITouchEventMessage) => {
		debug('Touch event received: ', data.x, data.y);
		sendMessageToActiveAppletIfExists(window, getState, {
			...data,
			type: messageTypePrefix + '.touch.propagate',
		});
	});
}

function createTouchEventChannel(window: Window) {
	const messageChannel = createChannel<TouchEvent>();
	window.addEventListener('touchstart', (event: TouchEvent) => messageChannel.put(event));
	window.addEventListener('touchend', (event: TouchEvent) => messageChannel.put(event));
	window.addEventListener('touchcancel', (event: TouchEvent) => messageChannel.put(event));
	window.addEventListener('touchmove', (event: TouchEvent) => messageChannel.put(event));

	return messageChannel;
}
