import GestureAction from '../../NativeDevice/Input/GestureAction';

// in the future this can contain complex logic to resolve all kinds of touch gestures

const DOUBLE_TAP_THRESHOLD = 500;

let lastTap: number | null = null;

export function handleTouch(type: string) {
	if (type === 'touchend') {
		const result: GestureAction[] = [GestureAction.SINGLE_TAP_UP];
		const now = new Date().valueOf();
		if (lastTap != null && now - lastTap <= DOUBLE_TAP_THRESHOLD) {
			result.push(GestureAction.DOUBLE_TAP);
		}
		lastTap = now;
		return result;
	}

	return [];
}

// for tests
export function resetLastTap() {
	lastTap = null;
}
