import { SocketConnected, SocketDisconnected } from '@signageos/actions/dist/Socket/socketActions';

export interface ISocketState {
	connected: boolean;
	wasDisconnected: boolean;
}

const initialState = {
	connected: false,
	wasDisconnected: false,
};

export function socket(state: ISocketState = initialState, action: any) {
	switch (action.type) {
		case SocketDisconnected:
			return {
				...state,
				connected: false,
				wasDisconnected: true,
			};
		case SocketConnected:
			return {
				...state,
				connected: true,
				wasDisconnected: false,
			};
		default:
			return state;
	}
}
