import Property from '../../Property/Property';
import { IPropertyStorage } from '../../Property/propertyStorage';
import IPinStorage from './IPinStorage';

export default class PinPropertyStorage implements IPinStorage {
	constructor(private readonly propertyStorage: IPropertyStorage) {}

	/**
	 * @returns Whether this storage has ever persisted any data.
	 */
	public async hasPersistedData(): Promise<boolean> {
		const pin = await this.propertyStorage.getValueOrDefault<any>(Property.PIN, undefined);
		return typeof pin !== 'undefined';
	}

	public async loadPin(): Promise<string | null> {
		return await this.propertyStorage.getValueOrDefault<string | null>(Property.PIN, null);
	}

	public async savePin(pin: string | null): Promise<void> {
		return await this.propertyStorage.setValue<string | null>(Property.PIN, pin);
	}
}
