export default interface ISecurity {
	/** @returns Whether PIN is set. */
	isSecure(): Promise<boolean>;
	verifyPin(pin: string): Promise<boolean>;
	/** @deprecated Use `verifyPin` instead. */
	getPin(): Promise<string>;
	setPin(newPin: string): Promise<void>;
	/**
	 * Listen for when the PIN changes.
	 * @returns A callback which removes the listener.
	 */
	onPinSet(listener: () => void): () => void;
}
