import { UpdateOrganization } from '@signageos/actions/dist/Organization/organizationActions';

export interface IOrganizationState {
	organizationTitle: string | null;
}

const initialState: IOrganizationState = {
	organizationTitle: null,
};

export function organization(state: IOrganizationState = initialState, action: UpdateOrganization) {
	switch (action.type) {
		case UpdateOrganization:
			return {
				...state,
				organizationTitle: action.title,
			};
		default:
			return state;
	}
}
