import { Connected, Disconnected } from '@signageos/actions/dist/Network/networkActions';

export interface INetworkState {
	connected: boolean;
}

const initialState: INetworkState = {
	connected: false,
};

export function network(state: INetworkState = initialState, action: Connected | Disconnected) {
	switch (action.type) {
		case Connected:
			return {
				...state,
				connected: true,
			};
		case Disconnected:
			return {
				...state,
				connected: false,
			};
		default:
			return state;
	}
}
