import { ChangeLicenseState, ViolationSeverity } from './licenseActions';

export interface ILicenseState {
	violationSeverity: ViolationSeverity;
}

const initialState: ILicenseState = {
	violationSeverity: ViolationSeverity.none,
};

export function license(state: ILicenseState = initialState, action: ChangeLicenseState): ILicenseState {
	switch (action.type) {
		case ChangeLicenseState:
			return { ...state, violationSeverity: action.severity };
		default:
			return state;
	}
}
