import { takeRight } from 'lodash';
import { put, takeEvery } from 'redux-saga/effects';
import { HandleKeyUp } from '@signageos/actions/dist/Input/keyActions';
import { HandleMotionSequence } from '@signageos/actions/dist/Input/motionActions';
import { ShowNumericKeyboard, HideNumericKeyboard } from '@signageos/actions/dist/Input/keyboardActions';
import GestureAction from '../../NativeDevice/Input/GestureAction';
import { KeyCode } from '../../NativeDevice/Input/KeyCode';
import wait from '@signageos/lib/dist/Timer/wait';

const SHOW_KEYBOARD_SEQUENCE = [
	GestureAction[GestureAction.DOUBLE_TAP],
	GestureAction[GestureAction.DOUBLE_TAP],
	GestureAction[GestureAction.DOUBLE_TAP],
	GestureAction[GestureAction.DOUBLE_TAP],
	GestureAction[GestureAction.DOUBLE_TAP],
	GestureAction[GestureAction.DOUBLE_TAP],
	GestureAction[GestureAction.DOUBLE_TAP],
	GestureAction[GestureAction.DOUBLE_TAP],
	GestureAction[GestureAction.DOUBLE_TAP],
	GestureAction[GestureAction.DOUBLE_TAP],
];

export function* bindNumericKeyboardSaga() {
	let lastMotionSequence: string[] = [];
	yield takeEvery(HandleMotionSequence, function* (motionSequence: HandleMotionSequence): IterableIterator<any> {
		try {
			lastMotionSequence = takeRight(
				motionSequence.sequence.filter((gestureAction: string) => SHOW_KEYBOARD_SEQUENCE.indexOf(gestureAction) !== -1),
				SHOW_KEYBOARD_SEQUENCE.length,
			);
		} catch (error) {
			console.error('bindPinKeyboardSaga motion sequence', error);
		}
	});
	yield takeEvery(HandleKeyUp, function* (handleKeyUp: HandleKeyUp) {
		try {
			if (handleKeyUp.keyCode === KeyCode[KeyCode.VOLUME_UP] && lastMotionSequence.join() === SHOW_KEYBOARD_SEQUENCE.join()) {
				yield put({
					type: ShowNumericKeyboard,
				} as ShowNumericKeyboard);
				yield wait(20e3);
				yield put({
					type: HideNumericKeyboard,
				} as HideNumericKeyboard);
			}
		} catch (error) {
			console.error('bindPinKeyboardSaga confirm key', error);
		}
	});
}
