import { put, fork, takeEvery } from 'redux-saga/effects';
import { HandleMotion, HandleMotionSequence } from '@signageos/actions/dist/Input/motionActions';
import GestureAction from '../../NativeDevice/Input/GestureAction';

export function* motionSequenceSaga(window: Window) {
	let cleanSequenceTimeout: number;
	let pressedSequence: (keyof GestureAction)[] = [];
	yield takeEvery(HandleMotion, function* (handleMotion: HandleMotion) {
		try {
			window.clearTimeout(cleanSequenceTimeout);
			yield fork(function* () {
				yield new Promise<void>((resolve: () => void) => {
					cleanSequenceTimeout = window.setTimeout(() => resolve(), 4 * 1e3);
				});
				pressedSequence = [];
				yield put({
					type: HandleMotionSequence,
					sequence: [...pressedSequence],
				} as HandleMotionSequence);
			});
			pressedSequence.push(handleMotion.gestureAction as keyof GestureAction);
			yield put({
				type: HandleMotionSequence,
				sequence: [...pressedSequence],
			} as HandleMotionSequence);
		} catch (error) {
			console.error('motionSequenceSaga', error);
		}
	});
}
