import { ShowNumericKeyboard, HideNumericKeyboard } from '@signageos/actions/dist/Input/keyboardActions';
import { HandleKeySequence } from '@signageos/actions/dist/Input/keyActions';
import { DeviceRemoteControlSet } from '../../Device/RemoteControl/deviceRemoteControlActions';
import { getNumericCode } from './numericSequence';

export interface IKeyboardState {
	showNumericKeyboard: boolean;
	numericCode: string | null;
}

const initialState: IKeyboardState = {
	showNumericKeyboard: false,
	numericCode: null,
};

export function keyboard(
	state: IKeyboardState = initialState,
	action: ShowNumericKeyboard | HideNumericKeyboard | HandleKeySequence | DeviceRemoteControlSet,
) {
	switch (action.type) {
		case ShowNumericKeyboard:
			return {
				...state,
				showNumericKeyboard: true,
			};
		case HideNumericKeyboard:
		case DeviceRemoteControlSet:
			return {
				...state,
				showNumericKeyboard: false,
			};
		case HandleKeySequence:
			return {
				...state,
				numericCode: getNumericCode(action.sequence),
			};
		default:
			return state;
	}
}
