import { bindAndTakeEvery } from '../../Socket/socketActionCreator';
import { put, takeEvery } from 'redux-saga/effects';
import { StartApplication } from '@signageos/actions/dist/Application/applicationActions';
import { UpdateAuthentication } from '@signageos/actions/dist/Device/Authentication/deviceAuthenticationActions';
import Property from '../../Property/Property';
import { IPropertyStorage } from '../../Property/propertyStorage';
import Debug from 'debug';

const debug = Debug('@signageos/front-display:Front:Device:deviceAuthenticationSagas');

export function* startupDeviceAuthHash(propertyStorage: IPropertyStorage) {
	yield takeEvery(StartApplication, function* () {
		try {
			const lastDeviceAuthHash: string | null = yield propertyStorage.getValueOrDefault<string | null>(
				Property.LAST_DEVICE_AUTH_HASH,
				null,
			);
			if (lastDeviceAuthHash) {
				yield put({
					type: UpdateAuthentication,
					authHash: lastDeviceAuthHash,
				} as UpdateAuthentication);
			}
		} catch (error) {
			debug('No ' + Property.LAST_DEVICE_AUTH_HASH + ' found', error);
		}
	});
}

export function* cacheDeviceAuthHash(propertyStorage: IPropertyStorage) {
	yield bindAndTakeEvery(UpdateAuthentication, function* (action: UpdateAuthentication) {
		try {
			yield propertyStorage.setValue<string>(Property.LAST_DEVICE_AUTH_HASH, action.authHash);
		} catch (error) {
			debug('cacheDeviceAuthHash failed', error);
		}
	});
}
