import { UpdateAuthentication } from '@signageos/actions/dist/Device/Authentication/deviceAuthenticationActions';

export interface IDeviceAuthenticationState {
	authHash: string | null;
}

const initialState: IDeviceAuthenticationState = {
	authHash: null,
};

export function deviceAuthentication(state: IDeviceAuthenticationState = initialState, action: UpdateAuthentication) {
	switch (action.type) {
		case UpdateAuthentication:
			return {
				...state,
				authHash: action.authHash,
			};
		default:
			return state;
	}
}
