import { bindAndTakeEvery } from '../../../Socket/socketActionCreator';
import { VerificationHashCreated } from '@signageos/actions/dist/Device/Verification/deviceVerificationActions';

export function* dispatchVerificationHash(window: Window) {
	yield bindAndTakeEvery(VerificationHashCreated, function* (verificationHashCreated: VerificationHashCreated): IterableIterator<any> {
		const message = {
			type: 'verificationHash',
			verificationHash: verificationHashCreated.verificationHash,
		};
		if (window.opener) {
			window.opener.postMessage(message, '*');
		}
	});
}
