import { put, takeEvery } from 'redux-saga/effects';
import { TriggerDisplayPowerOn, TriggerDisplayPowerOff, TriggerAppletOn, TriggerAppletOff } from '../Power/devicePowerActionActions';
import Debug from 'debug';
import IProprietaryResolver, { DisplayEvent, TimerEvent } from '../../../Timer/IProprietaryTimerResolver';
import { channel } from 'redux-saga';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import Responsibility from '../../../Feature/Responsibility';

const debug = Debug('@signageos/front-display:Front:Device:Timer:timerControllerSagas');

const timerCheckingChannel = channel<TriggerDisplayPowerOn | TriggerDisplayPowerOff>();
const timerCheckingChannelApplet = channel<TriggerAppletOn | TriggerAppletOff>();

export function* displayTimerChecking(responsibilities: IResponsibilities, timersManager: IProprietaryResolver<DisplayEvent>) {
	if (!responsibilities.has(Responsibility.TIMERS)) {
		return;
	}

	debug('timerChecking start');

	timersManager
		.on(DisplayEvent.POWER_ON, () => {
			debug('turning display on');
			timerCheckingChannel.put({
				type: TriggerDisplayPowerOn,
			});
		})
		.on(DisplayEvent.POWER_OFF, () => {
			debug('turning display off');
			timerCheckingChannel.put({
				type: TriggerDisplayPowerOff,
			});
		});
	// TODO Clean up timersManager when the saga is done.

	yield takeEvery<TriggerDisplayPowerOn | TriggerDisplayPowerOff>(
		timerCheckingChannel,
		function* (action: TriggerDisplayPowerOn | TriggerDisplayPowerOff) {
			yield put(action);
		},
	);
}

export function* appletTimerChecking(responsibilities: IResponsibilities, timersManager: IProprietaryResolver<TimerEvent>) {
	if (!responsibilities.has(Responsibility.TIMERS)) {
		return;
	}

	timersManager
		.on(TimerEvent.TIMER_ON, () => {
			debug('enabling applet');
			timerCheckingChannelApplet.put({
				type: TriggerAppletOn,
			});
		})
		.on(TimerEvent.TIMER_OFF, () => {
			debug('disabling applet');
			timerCheckingChannelApplet.put({
				type: TriggerAppletOff,
			});
		});
	// TODO Clean up timersManager when the saga is done.

	yield takeEvery<TriggerAppletOn | TriggerAppletOff>(timerCheckingChannelApplet, function* (action: TriggerAppletOn | TriggerAppletOff) {
		yield put(action);
	});
}
