import { bindAndTakeEvery } from '../../../Socket/socketActionCreator';
import { put, takeEvery } from 'redux-saga/effects';
import { StartApplication } from '@signageos/actions/dist/Application/applicationActions';
import { AuthenticationSucceed } from '@signageos/actions/dist/Authentication/authenticationActions';
import { DeviceRemoteControlSet } from '../../../Device/RemoteControl/deviceRemoteControlActions';
import IFrontDriver from '../../../NativeDevice/Front/IFrontDriver';
import Debug from 'debug';

const debug = Debug('@signageos/front-display:Front:Device:RemoteControl:deviceRemoteControlSagas');

export function* startupDeviceRemoteControlSettingsSaga(getNativeDriver: () => IFrontDriver) {
	yield bindAndTakeEvery(AuthenticationSucceed, startupDeviceRemoteControlSettings, getNativeDriver);
	yield takeEvery(StartApplication, startupDeviceRemoteControlSettings, getNativeDriver);
}

function* startupDeviceRemoteControlSettings(getNativeDriver: () => IFrontDriver) {
	try {
		const nativeDriver = getNativeDriver();
		const enabled: boolean = yield nativeDriver.remoteControlIsEnabled();
		yield put({
			type: DeviceRemoteControlSet,
			enabled,
		} as DeviceRemoteControlSet);
	} catch (error) {
		debug("Couldn't determine if the remote control is enabled during startup", error);
	}
}
