import CronPowerActionScheduler from '../../../NativeDevice/Power/CronPowerActionScheduler';
import DefaultPowerActionTimer from '../../../NativeDevice/Power/DefaultPowerActionTimer';
import IPowerActionTimer from '../../../NativeDevice/Power/IPowerActionTimer';
import { createPowerActionTimerPropertyStorage } from '../../../NativeDevice/Power/powerActionTimerStorages';
import Property from '../../../Property/Property';
import { IPropertyStorage } from '../../../Property/propertyStorage';
import FrontPowerActionExecutor from './FrontPowerActionExecutor';

export function createFrontPowerActionTimer(propertyStorage: IPropertyStorage, executor: FrontPowerActionExecutor): IPowerActionTimer {
	const storage = createPowerActionTimerPropertyStorage(propertyStorage, Property.POWER_ACTIONS_SCHEDULE_SETTINGS_FRONT);
	const scheduler = new CronPowerActionScheduler();
	return new DefaultPowerActionTimer(storage, scheduler, executor);
}
