import { PerformDeviceDeprovision } from '@signageos/actions/dist/Device/Deprovision/deviceDeprovisionActions';
import { IResponsibilities } from '../../../Feature/Responsibilities';
import Responsibility from '../../../Feature/Responsibility';
import IFrontDriver from '../../../NativeDevice/Front/IFrontDriver';
import { IFrontManagementDriver } from '../../../NativeDevice/Management/IManagementDriver';
import { takeEveryAndBindWhenPlatform } from '../../../Socket/socketActionCreator';

export function* deviceDeprovision(
	getNativeDriver: () => IFrontDriver,
	getManagementDriver: () => IFrontManagementDriver,
	responsibilities: IResponsibilities,
	sessionIdKey: string,
) {
	if (responsibilities.has(Responsibility.DEPROVISIONING)) {
		yield takeEveryAndBindWhenPlatform(PerformDeviceDeprovision, function* () {
			try {
				yield Promise.allSettled([
					getNativeDriver().security.setPin(''),
					getNativeDriver().remoteControlSetEnabled(true),
					getNativeDriver().hardware.led.setColor('#00000'),
					getManagementDriver().wifi.disconnect(),
					getManagementDriver().wifi.disable(),
					getNativeDriver().setSessionId(sessionIdKey, ''),
				]);
			} catch (error) {
				console.error('deviceDeprovision failed', error);
			}
		});
	}
}
