import { ConnectDevice, DisconnectDevice } from '@signageos/actions/dist/Device/Connect/deviceConnectActions';

export interface IDeviceConnectState {
	connectedBaseUrl: string | null;
}

export const deviceConnect = (
	state: IDeviceConnectState = { connectedBaseUrl: null },
	action: ConnectDevice | DisconnectDevice,
): IDeviceConnectState => {
	switch (action.type) {
		case ConnectDevice:
			return { connectedBaseUrl: action.remoteIp };
		case DisconnectDevice:
			return { connectedBaseUrl: null };
		default:
			return state;
	}
};
