import { StartApplication, UpdateBaseUrl } from '@signageos/actions/dist/Application/applicationActions';
import { ChangeSubscriptionToOpen, ChangeSubscriptionToPlatform } from '../../Device/Configuration/deviceConfigurationActions';
import { SubscriptionType } from '../../Display/IConfig';

export interface IApplicationState {
	started: boolean;
	baseUrl: string | null;
	/**
	 * null means never determined by server.
	 * It could be even platform but first-time the server is connected, the subscriptionType is stored to storage.
	 * On every start, the stored subscriptionType is used.
	 */
	subscriptionType: SubscriptionType | null;
}

const initialState: IApplicationState = {
	started: false,
	baseUrl: null,
	subscriptionType: null,
};

export function application(
	state: IApplicationState = initialState,
	action: UpdateBaseUrl | StartApplication | ChangeSubscriptionToOpen | ChangeSubscriptionToPlatform,
): IApplicationState {
	switch (action.type) {
		case StartApplication:
			return {
				...state,
				started: true,
			};
		case UpdateBaseUrl:
			return {
				...state,
				baseUrl: action.baseUrl,
			};
		case ChangeSubscriptionToOpen:
			return {
				...state,
				subscriptionType: SubscriptionType.open,
			};
		case ChangeSubscriptionToPlatform:
			return {
				...state,
				subscriptionType: SubscriptionType.platform,
			};
		default:
			return state;
	}
}
