import wait from '@signageos/lib/dist/Timer/wait';
import { IFrontState } from '../frontReducers';
import Debug from 'debug';
const debug = Debug('@signageos/front-display:Front:Applet:sendAppletMessage');

export default async function sendAppletMessage(window: Window, appletIframeId: string | null, message: any) {
	if (appletIframeId === null) {
		throw new Error('Iframe id is null in sendAppletMessage');
	}
	const appletIframe = window.document.getElementById(appletIframeId) as HTMLIFrameElement;
	if (!appletIframe) {
		throw new Error('Not found active applet iframe by id ' + appletIframeId);
	}
	await wait(0);
	if (!appletIframe.contentWindow) {
		throw new Error(
			'Iframe with id ' + appletIframeId + ' was removed. ' + 'postMessage(' + JSON.stringify(message) + ') was not processed',
		);
	}
	debug('sending message to applet ' + appletIframeId, message);
	appletIframe.contentWindow.window.postMessage(message, '*');
}

export async function sendMessageToActiveAppletIfExists(window: Window, getState: () => IFrontState, message: any) {
	try {
		const appletIframeId = getState().applet.activeAppletIframeId;
		if (appletIframeId) {
			await sendAppletMessage(window, appletIframeId, message);
		} else {
			debug('no active applet for message', message);
		}
	} catch (error) {
		debug('sendMessageToActiveAppletIfExists failed', error);
	}
}
