import browserHandler from './Browser/appletBrowserHandler';
import commandHandler from './Command/appletCommandHandler';
import deviceInfoHandler from './DeviceInfo/appletDeviceInfoHandler';
import displayHandler from './Display/appletDisplayHandler';
import fileSystemHandler from './FileSystem/appletFileSystemHandler';
import hardwareBarcodeScannerHandler from './Hardware/appletHardwareBarcodeScannerHandler';
import hardwareHandler from './Hardware/appletHardwareHandler';
import hardwareSerialPortHandler from './Hardware/appletHardwareSerialPortHandler';
import { HandlerResult, IBaseHandlerParams, IHandlerParams, IManagementHandlerParams } from './IHandler';
import pingHandler from './Main/pingHandler';
import appletRefreshHandler from './Main/refreshHandler';
import managementNetworkHandler from './Management/Network/appletManagementNetworkHandler';
import managementProxyHandler from './Management/Proxy/appletManagementProxyHandler';
import managementSystemInfoHandler from './Management/SystemInfo/appletManagementSystemInfoHandler';
import wifiHandler from './Management/Wifi/appletWifiHandler';
import managementHandler from './Management/appletManagementHandler';
import monitorsHandler from './Monitors/appletMonitorsHandler';
import nativeCommandHandler from './Native/nativeCommandHandler';
import osdHandler from './OSD/appletOSDHandler';
import offlineCacheHandler from './OfflineCache/appletOfflineCacheHandler';
import streamHandler from './Stream/appletStreamHandler';
import syncHandler from './Sync/appletSyncHandler';
import timingHandler from './Timing/appletTimingHandler';
import touchHandler from './Touch/appletTouchHandler';
import videoHandler from './Video/appletVideoHandler';
import secretsHandler from './Secrets/appletSecretsHandler';

type ManagementMessageHandler = (parameters: IManagementHandlerParams) => HandlerResult;
type FrontMessageHandler = (parameters: IHandlerParams) => HandlerResult;

const managementHandlers: ManagementMessageHandler[] = [
	wifiHandler,
	managementHandler,
	managementNetworkHandler,
	monitorsHandler,
	managementProxyHandler,
	managementSystemInfoHandler,
	nativeCommandHandler,
	secretsHandler,
];

const frontHandlers: FrontMessageHandler[] = [
	appletRefreshHandler,
	pingHandler,
	videoHandler,
	streamHandler,
	commandHandler,
	hardwareHandler,
	hardwareBarcodeScannerHandler,
	hardwareSerialPortHandler,
	touchHandler,
	offlineCacheHandler,
	browserHandler,
	timingHandler,
	syncHandler,
	fileSystemHandler,
	displayHandler,
	deviceInfoHandler,
	osdHandler,
];

export function* handleAppletManagementMessage(parameters: IManagementHandlerParams): HandlerResult {
	return yield handleAppletMessageWithHandlers(parameters, managementHandlers);
}

export function* handleAppletMessage(parameters: IHandlerParams): HandlerResult {
	const handlers = [...managementHandlers, ...frontHandlers];
	return yield handleAppletMessageWithHandlers(parameters, handlers);
}

function* handleAppletMessageWithHandlers<TParams extends IBaseHandlerParams>(
	parameters: TParams,
	handlers: ((parameters: TParams) => HandlerResult)[],
): HandlerResult {
	for (let index = 0; index < handlers.length; index++) {
		const handler = handlers[index];
		const response = yield handler(parameters);

		if (response !== null) {
			return response;
		}
	}

	const { messageTypePrefix, data } = parameters;

	const overlookedMessages = [messageTypePrefix + '_loader.ready', messageTypePrefix + '_api.ready'];
	if (overlookedMessages.indexOf(data.type) === -1) {
		throw new Error('Unknown message type: ' + data.type);
	}

	return {};
}
