import { put, takeEvery } from 'redux-saga/effects';
import { IFrontState } from '../../frontReducers';
import IDriver from '../../../NativeDevice/Front/IFrontDriver';
import { EmitVideoEvent } from './EmitVideoEvent';
import { sendMessageToActiveAppletIfExists } from '../sendAppletMessage';
import ISynchronizer from '../../../Synchronization/ISynchronizer';
import { ActiveAppletRestore } from '../activeAppletActions';
import { StartAppletIframe } from '../../AppletTiming/appletTimingActions';

export function* activeAppletRestore(getNativeDriver: () => IDriver, getSynchronizer: () => ISynchronizer) {
	yield takeEvery(ActiveAppletRestore, function* () {
		try {
			yield getNativeDriver().restoreDisplayArea();
		} catch (error) {
			console.error('activeAppletRestore restoreDisplayArea failed', error);
		}
		try {
			const synchronizer = getSynchronizer();
			const isConnected: boolean = yield synchronizer.isConnected();
			if (isConnected) {
				yield synchronizer.close();
			}
		} catch (error) {
			console.error('activeAppletRestore synchronizer close failed', error);
		}
	});
}

export function* restoreOnAppletChange() {
	yield takeEvery(StartAppletIframe, function* () {
		try {
			yield put({ type: ActiveAppletRestore } as ActiveAppletRestore);
		} catch (error) {
			console.error('restoreOnAppletChange failed', error);
		}
	});
}

export function* videoEventEmitting(window: Window, messageTypePrefix: string, getState: () => IFrontState) {
	yield takeEvery(EmitVideoEvent, function* (action: EmitVideoEvent) {
		const event = action.event;
		yield sendMessageToActiveAppletIfExists(window, getState, {
			type: messageTypePrefix + '.video.' + event.type,
			uri: event.srcArguments.uri,
			x: event.srcArguments.x,
			y: event.srcArguments.y,
			width: event.srcArguments.width,
			height: event.srcArguments.height,
		});
	});
}
