import { put } from 'redux-saga/effects';
import { HandleMotion } from '@signageos/actions/dist/Input/motionActions';
import ITouchEventMessage from './ITouchEventMessage';
import IDriver from '../../../NativeDevice/Front/IFrontDriver';
import GestureAction from '../../../NativeDevice/Input/GestureAction';
import { handleTouch } from '../../Touch/touchGestureResolver';
import { HandlerResult, IHandlerParams } from '../IHandler';
import Debug from 'debug';

const debug = Debug('@signageos/front-display:Front:Applet:Touch:appletTouchHandler');

export function* handleTouchMessage(
	messageTypePrefix: string,
	data: ITouchEventMessage,
	_nativeDriver: IDriver,
	_window: Window,
	_appletUid: string,
	_timingChecksum: string,
) {
	switch (data.type) {
		case messageTypePrefix + '.touch.event':
			try {
				const gestures = handleTouch(data.eventType);
				if (gestures.length > 0) {
					for (let gesture of gestures) {
						yield put({
							type: HandleMotion,
							gestureAction: GestureAction[gesture],
						} as HandleMotion);
					}
				}
			} catch (error) {
				debug('handleTouchMessage failed', error);
			}
			return {};
		default:
			return null;
	}
}

export default function* touchHandler({
	messageTypePrefix,
	data,
	frontDriver,
	window,
	appletUid,
	timingChecksum,
}: IHandlerParams): HandlerResult {
	return yield handleTouchMessage(messageTypePrefix, data as ITouchEventMessage, frontDriver, window, appletUid, timingChecksum);
}
