import { SynchronizerType } from '../../../Synchronization/PolymorphicSynchronizer/IPolymorphicSynchronizer';
import { SyncEngine } from './ISyncConnectMessage';

export function appletSyncEngineToSynchronizerSynchronizerType(engine: SyncEngine | undefined): SynchronizerType | undefined {
	if (engine === undefined) {
		return undefined;
	}

	switch (engine) {
		case SyncEngine.SyncServer:
			return SynchronizerType.SyncServer;
		// keep Udp for backwards compatibility, it's the same as P2PLocal
		case SyncEngine.Udp:
		case SyncEngine.P2PLocal:
			return SynchronizerType.P2PLocal;
		default:
			throw new Error('Unknown sync engine: ' + engine);
	}
}
