import { takeEvery } from 'redux-saga/effects';
import { IFrontState } from '../../frontReducers';
import { sendMessageToActiveAppletIfExists } from '../sendAppletMessage';
import { StreamConnected, StreamDisconnected, StreamError, StreamTracksChanged } from '../../../Stream/streamActions';

export function* streamEventEmitting(window: Window, messageTypePrefix: string, getState: () => IFrontState) {
	yield takeEvery(StreamError, function* (action: StreamError) {
		yield sendMessageToActiveAppletIfExists(window, getState, {
			...createMessage(messageTypePrefix, 'stream.error', action),
			protocol: action.protocol,
			errorMessage: action.errorMessage,
		});
	});

	yield takeEvery(StreamConnected, function* (action: StreamConnected) {
		yield sendMessageToActiveAppletIfExists(window, getState, {
			...createMessage(messageTypePrefix, 'stream.connected', action),
			protocol: action.protocol,
		});
	});

	yield takeEvery(StreamDisconnected, function* (action: StreamDisconnected) {
		yield sendMessageToActiveAppletIfExists(window, getState, {
			...createMessage(messageTypePrefix, 'stream.disconnected', action),
			protocol: action.protocol,
		});
	});

	yield takeEvery(StreamTracksChanged, function* (action: StreamTracksChanged) {
		yield sendMessageToActiveAppletIfExists(window, getState, {
			...createMessage(messageTypePrefix, 'stream.tracks_changed', action),
			tracks: action.tracks,
		});
	});
}

function createMessage(
	messageTypePrefix: string,
	type: string,
	action: StreamError | StreamConnected | StreamDisconnected | StreamTracksChanged,
) {
	return {
		type: messageTypePrefix + '.' + type,
		uri: action.uri,
		x: action.x,
		y: action.y,
		width: action.width,
		height: action.height,
	};
}
