import { IStreamOptions, TrackType } from '../../../Stream/IStreamPlayer';
import StreamProtocol from '../../../Stream/StreamProtocol';
import IMessage from '../IMessage';
import { IVideoSrcArguments } from '../../../Video/IVideoSrcArguments';

export interface IStreamMessage extends IMessage {
	uri: string;
	x: number;
	y: number;
	width: number;
	height: number;
}

export interface IStreamPrepareMessage extends IStreamMessage {
	/**
	 * @deprecated replaced with options @see IStreamOptions
	 */
	protocol?: keyof typeof StreamProtocol;
	options?: IStreamOptions;
}

export interface IStreamPlayMessage extends IStreamMessage {
	/**
	 * @deprecated replaced with options @see IStreamOptions
	 */
	protocol?: keyof typeof StreamProtocol;

	/**
	 * @deprecated
	 */
	protocolType?: string; // backwards compatibility; TODO : remove when backwards compatibility is no longer needed
	options?: IStreamOptions;
}

export interface IStreamStopMessage extends IStreamMessage {}

export interface IStreamPauseMessage extends IStreamMessage {}

export interface IStreamResumeMessage extends IStreamMessage {}

export interface IStreamGetTracksMessage extends IStreamMessage {
	videoId: IVideoSrcArguments;
}
export interface IStreamSelectTrackMessage extends IStreamMessage {
	videoId: IVideoSrcArguments;
	trackType: TrackType;
	groupId: string;
	trackIndex: number;
}

export interface IStreamResetTrackMessage extends IStreamMessage {
	videoId: IVideoSrcArguments;
	trackType: TrackType;
	groupId?: string;
}
