import { takeEvery } from 'redux-saga/effects';
import { IFrontState } from '../../frontReducers';
import { sendMessageToActiveAppletIfExists } from '../sendAppletMessage';
import { IFrontManagementDriver } from '../../../NativeDevice/Management/IManagementDriver';
import { StartApplication } from '@signageos/actions/dist/Application/applicationActions';
import { createChannel, takeEvery as takeEventChannelMessage } from '../../../ReduxSaga/channels';

export function* proximitySensorStatusChangeEmitting(
	window: Window,
	messageTypePrefix: string,
	getNativeDriver: () => IFrontManagementDriver,
	getState: () => IFrontState,
) {
	yield takeEvery(StartApplication, function* () {
		try {
			const nativeDriver = getNativeDriver();
			const proximitySensorChangesChannel = createChannel((put: (message: boolean) => void) => {
				nativeDriver.sensors.proximity.addStateChangeListener(put);
			});
			yield takeEventChannelMessage(proximitySensorChangesChannel, function* (detected: boolean) {
				yield sendMessageToActiveAppletIfExists(window, getState, {
					type: messageTypePrefix + '.sensors.proximity.change',
					detected,
				});
			});
		} catch (error) {
			console.error('proximitySensorStatusChangeEmitting failed', error);
		}
	});
}
