import { HandlerResult, IHandlerParams } from '../IHandler';
import IMessage from '../IMessage';
import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';

const DecryptMessage = 'hug.secrets.decryptSecret';
export interface DecryptMessage extends IMessage {
	type: typeof DecryptMessage;
	value: string;
}

export function* handleSecretsMessage(messageTypePrefix: string, data: DecryptMessage, managementDriver: IManagementDriver): HandlerResult {
	switch (data.type) {
		case messageTypePrefix + '.secret_decrypt':
			return yield handleDecryptValue(data.value, managementDriver);
		default:
			return null;
	}
}

export default function* secretsHandler({ messageTypePrefix, data, managementDriver }: IHandlerParams): HandlerResult {
	return yield handleSecretsMessage(messageTypePrefix, data as DecryptMessage, managementDriver);
}

async function handleDecryptValue(value: string, managementDriver: IManagementDriver) {
	const decrypted = await managementDriver.secretManager.decryptJweGeneralToUtf8(JSON.parse(value));
	return {
		decryptedValue: decrypted,
	};
}
