import IManagementDriver from '../../../NativeDevice/Management/IManagementDriver';
import { HandlerResult } from '../IHandler';
import { IMdcSendOneMessage } from './IMDCSendOneMessage';
import { ManagementCapabilities } from '@signageos/common-types/dist/Device/Capabilities/ManagementCapabilities';
import { IMdcSendOneResponse } from '../../../NativeDevice/NativeCommand/MDC/IMdc';

const PREFIX = 'native_commands';

export function* handleNativeCommandMessage(
	messageTypePrefix: string,
	data: IMdcSendOneMessage,
	managementDriver: IManagementDriver,
): HandlerResult {
	switch (data.type) {
		case `${messageTypePrefix}.${PREFIX}.mdc.send_one`:
			return yield handleMdcSendOne(data, managementDriver, false);
		case `${messageTypePrefix}.${PREFIX}.mdc.send_one_raw`:
			return yield handleMdcSendOne(data, managementDriver, true);
		default:
			return null;
	}
}

export default function* nativeCommandHandler({ messageTypePrefix, data, managementDriver }: any): HandlerResult {
	return yield handleNativeCommandMessage(messageTypePrefix, data, managementDriver);
}

async function handleMdcSendOne(
	data: IMdcSendOneMessage,
	managementDriver: IManagementDriver,
	raw: boolean,
): Promise<{ commandResponse: IMdcSendOneResponse }> {
	const isSupported = await managementDriver.managementSupports(ManagementCapabilities.NATIVE_COMMANDS_MDC);
	if (!isSupported) {
		throw new Error('Native MDC commands are not supported on this device.');
	}
	if (raw) {
		const rawCommandResponse = await managementDriver.nativeCommands.mdc.sendOneRaw(data.ipAddress, data.data);
		return { commandResponse: rawCommandResponse };
	}
	const commandResponse = await managementDriver.nativeCommands.mdc.sendOne(data.ipAddress, data.command, data.data);
	return { commandResponse };
}
