import IManagementDriver from '../../../../NativeDevice/Management/IManagementDriver';
import { EmptyObject } from '../../../../Util/EmptyObject';
import { HandlerResult, IHandlerParams } from '../../IHandler';
import { IIsEnabledMessage, IGetConnectedToMessage, ISetManualMessage, IDisableMessage } from './messageTypes';

const PREFIX = 'management';

export function* handleManagementProxyMessage(
	messageTypePrefix: string,
	data: IIsEnabledMessage | IGetConnectedToMessage | ISetManualMessage | IDisableMessage,
	managementDriver: IManagementDriver,
): HandlerResult {
	switch (data.type) {
		case `${messageTypePrefix}.${PREFIX}.proxy_is_enabled`:
			return yield handleIsEnabled(managementDriver);

		case `${messageTypePrefix}.${PREFIX}.proxy_set_manual`:
			return yield handleSetManual(managementDriver, data as ISetManualMessage);

		case `${messageTypePrefix}.${PREFIX}.proxy_disable`:
			return yield handleDisable(managementDriver);

		case `${messageTypePrefix}.${PREFIX}.proxy_get_connected_to`:
			return yield handleGetConnectedTo(managementDriver);

		default:
			return null;
	}
}

async function handleIsEnabled(managementDriver: IManagementDriver): Promise<{ isEnabled: boolean }> {
	const isEnabled = await managementDriver.proxy.isEnabled();
	return {
		isEnabled,
	};
}

async function handleSetManual(managementDriver: IManagementDriver, data: ISetManualMessage): Promise<EmptyObject> {
	await managementDriver.proxy.setManual(data.uri, data.port, data.username, data.password);
	return {};
}

async function handleDisable(managementDriver: IManagementDriver): Promise<EmptyObject> {
	await managementDriver.proxy.disable();
	return {};
}

async function handleGetConnectedTo(managementDriver: IManagementDriver): Promise<{ connectedTo: string }> {
	const connectedTo = await managementDriver.proxy.getConnectedTo();
	return {
		connectedTo,
	};
}

export default function* managementHandler({ messageTypePrefix, data, managementDriver }: IHandlerParams): HandlerResult {
	return yield handleManagementProxyMessage(
		messageTypePrefix,
		data as IIsEnabledMessage | IDisableMessage | ISetManualMessage | IGetConnectedToMessage,
		managementDriver,
	);
}
