import { performAppletRefresh } from '../../Device/Power/devicePowerActionSagas';
import { HandlerResult, IHandlerParams } from '../IHandler';
import IMessage from '../IMessage';

const appletRefreshMessage = 'hug.applet.refresh';
interface AppletRefreshMessage extends IMessage {
	type: typeof appletRefreshMessage;
}

function* handleAppletRefreshMessage(messageTypePrefix: string, data: AppletRefreshMessage) {
	switch (data.type) {
		case messageTypePrefix + '.applet_refresh':
			yield performAppletRefresh();
			return {};
		default:
			return null;
	}
}

export default function* appletRefreshHandler({ messageTypePrefix, data }: IHandlerParams): HandlerResult {
	return yield handleAppletRefreshMessage(messageTypePrefix, data as AppletRefreshMessage);
}
