import { put } from 'redux-saga/effects';
import IPingMessage from './IPingMessage';
import IDriver from '../../../NativeDevice/Front/IFrontDriver';
import { AppletPing } from '@signageos/actions/dist/Applet/activeAppletActions';
import { HandlerResult, IHandlerParams } from '../IHandler';

function* handlePingMessage(
	messageTypePrefix: string,
	data: IPingMessage,
	_nativeDriver: IDriver,
	appletUid: string,
	timingChecksum: string,
) {
	switch (data.type) {
		case messageTypePrefix + '.ping':
			yield put({
				type: AppletPing,
				appletUid,
				timingChecksum,
			} as AppletPing);
			return {};
		default:
			return null;
	}
}

export default function* pingHandler({ messageTypePrefix, data, frontDriver, appletUid, timingChecksum }: IHandlerParams): HandlerResult {
	return yield handlePingMessage(messageTypePrefix, data as IPingMessage, frontDriver, appletUid, timingChecksum);
}
