import { takeEvery } from 'redux-saga/effects';
import { IFrontState } from '../../frontReducers';
import { sendMessageToActiveAppletIfExists } from '../sendAppletMessage';
import { HandleKeyUp } from '@signageos/actions/dist/Input/keyActions';
import { KeyCode } from '../../../NativeDevice/Input/KeyCode';

export function* inputKeysEmitting(window: Window, messageTypePrefix: string, getState: () => IFrontState) {
	yield takeEvery(HandleKeyUp, handleKeyUpAction, window, messageTypePrefix, getState);
}

export function* handleKeyUpAction(window: Window, messageTypePrefix: string, getState: () => IFrontState, action: HandleKeyUp) {
	yield sendMessageToActiveAppletIfExists(window, getState, {
		type: messageTypePrefix + '.input.keyup',
		keyCode: KeyCode[action.keyCode as any as KeyCode],
		keyName: action.keyCode,
	});
}
