import ErrorCodes from './ErrorCodes';
import ErrorSuggestions from './ErrorSuggestions';

export interface IBaseSosErrorParams {
	message: string;
	code: ErrorCodes;
	suggestion?: ErrorSuggestions;
}

export interface IBaseSosErrorParamsWithDocs extends IBaseSosErrorParams {
	pathToDocs?: string;
}

export interface ISosErrorParams extends IBaseSosErrorParamsWithDocs {
	kind: 'sosError';
}

export default class SosError extends Error {
	public code: ErrorCodes;
	public suggestion?: ErrorSuggestions;
	public pathToDocs?: string;

	constructor({ message, code, suggestion, pathToDocs }: ISosErrorParams) {
		super(message);
		this.name = 'SosError';
		this.code = code;
		this.suggestion = suggestion;
		this.pathToDocs = pathToDocs;
	}
}
