import InternalError, { IBaseInternalErrorParamsWithOrigin } from './InternalError';
import { IBaseSosErrorParams } from './SosError';

export interface IInternalVideoErrorParams extends IBaseSosErrorParams {
	kind: 'internalVideoError';
}

export interface IInternalVideoErrorErrorParamsWithOrigin extends IBaseInternalErrorParamsWithOrigin {
	kind: 'internalVideoErrorWithOrigin';
}

export default class InternalVideoError extends InternalError {
	public static readonly PATH_TO_DOCS: string = '/api/js/js-sync-playback';

	constructor(parameters: IInternalVideoErrorParams | IInternalVideoErrorErrorParamsWithOrigin) {
		if (parameters.kind === 'internalVideoError') {
			super({
				...parameters,
				pathToDocs: InternalVideoError.PATH_TO_DOCS,
				kind: 'internalError',
			});
		} else {
			super({
				...parameters,
				pathToDocs: InternalVideoError.PATH_TO_DOCS,
				kind: 'internalErrorWithOrigin',
			});
		}
		this.name = 'InternalVideoError';
	}
}
