import InternalError, { IBaseInternalErrorParamsWithOrigin } from './InternalError';
import { IBaseSosErrorParams } from './SosError';

export interface IInternalSynchronizerErrorParams extends IBaseSosErrorParams {
	kind: 'internalSynchronizerError';
}

export interface IInternalSynchronizerErrorErrorParamsWithOrigin extends IBaseInternalErrorParamsWithOrigin {
	kind: 'internalSynchronizerErrorWithOrigin';
}

export default class InternalSynchronizerError extends InternalError {
	public static readonly PATH_TO_DOCS: string = '/api/js/js-sync-playback';

	constructor(parameters: IInternalSynchronizerErrorParams | IInternalSynchronizerErrorErrorParamsWithOrigin) {
		if (parameters.kind === 'internalSynchronizerError') {
			super({
				...parameters,
				pathToDocs: InternalSynchronizerError.PATH_TO_DOCS,
				kind: 'internalError',
			});
		} else {
			super({
				...parameters,
				pathToDocs: InternalSynchronizerError.PATH_TO_DOCS,
				kind: 'internalErrorWithOrigin',
			});
		}
		this.name = 'InternalSynchronizerError';
	}
}
