import InternalError, { IBaseInternalErrorParamsWithOrigin } from './InternalError';
import { IBaseSosErrorParams } from './SosError';

export interface IInternalOfflineCacheErrorParams extends IBaseSosErrorParams {
	kind: 'internalOfflineCacheError';
}

export interface IInternalOfflineCacheErrorErrorParamsWithOrigin extends IBaseInternalErrorParamsWithOrigin {
	kind: 'internalOfflineCacheErrorWithOrigin';
}

export default class InternalOfflineCacheError extends InternalError {
	constructor(parameters: IInternalOfflineCacheErrorParams | IInternalOfflineCacheErrorErrorParamsWithOrigin) {
		if (parameters.kind === 'internalOfflineCacheError') {
			super({
				...parameters,
				kind: 'internalError',
			});
		} else {
			super({
				...parameters,
				kind: 'internalErrorWithOrigin',
			});
		}
		this.name = 'InternalOfflineCacheError';
	}
}
