import InternalError, { IBaseInternalErrorParamsWithOrigin } from './InternalError';
import { IBaseSosErrorParams } from './SosError';

export interface IInternalNativeCacheErrorParams extends IBaseSosErrorParams {
	kind: 'internalNativeCacheError';
}

export interface IInternalNativeCacheErrorErrorParamsWithOrigin extends IBaseInternalErrorParamsWithOrigin {
	kind: 'internalNativeCacheErrorWithOrigin';
}

export default class InternalNativeCacheError extends InternalError {
	constructor(parameters: IInternalNativeCacheErrorParams | IInternalNativeCacheErrorErrorParamsWithOrigin) {
		if (parameters.kind === 'internalNativeCacheError') {
			super({
				...parameters,
				kind: 'internalError',
			});
		} else {
			super({
				...parameters,
				kind: 'internalErrorWithOrigin',
			});
		}
		this.name = 'InternalNativeCacheError';
	}
}
