import InternalError, { IBaseInternalErrorParamsWithOrigin } from './InternalError';
import { IBaseSosErrorParams } from './SosError';

export interface IInternalHardwareErrorErrorParams extends IBaseSosErrorParams {
	kind: 'internalHardwareError';
}

export interface IInternalHardwareErrorParamsWithOrigin extends IBaseInternalErrorParamsWithOrigin {
	kind: 'internalHardwareErrorWithOrigin';
}

export default class InternalHardwareError extends InternalError {
	public static readonly PATH_TO_DOCS: string = '/api/js/js-hardware';

	constructor(parameters: IInternalHardwareErrorErrorParams | IInternalHardwareErrorParamsWithOrigin) {
		if (parameters.kind === 'internalHardwareError') {
			super({
				...parameters,
				pathToDocs: InternalHardwareError.PATH_TO_DOCS,
				kind: 'internalError',
			});
		} else {
			super({
				...parameters,
				pathToDocs: InternalHardwareError.PATH_TO_DOCS,
				kind: 'internalErrorWithOrigin',
			});
		}
		this.name = 'InternalHardwareError';
	}
}
