import AppletError from './AppletError';
import { IBaseSosErrorParams } from './SosError';

export interface IAppletCommandErrorParams extends IBaseSosErrorParams {
	kind: 'appletCommandError';
}

export default class AppletCommandError extends AppletError {
	public static readonly PATH_TO_DOCS: string = '/api/js/js-command';

	constructor(parameters: IAppletCommandErrorParams) {
		super({
			...parameters,
			pathToDocs: AppletCommandError.PATH_TO_DOCS,
			kind: 'appletError',
		});
		this.name = 'AppletCommandError';
	}
}
